<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Branding Sekolah') ?></title>

  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">

  <style>
    * {
      box-sizing: border-box;
    }
    
    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;
      background: #f6f8fb;
      margin: 0;
      padding: 0;
    }
    
    .wrap {
      max-width: 980px;
      margin: 0 auto;
      padding: 24px 16px;
    }
    
    .page-header {
      margin-bottom: 24px;
    }
    
    .page-title {
      font-size: 28px;
      font-weight: 600;
      color: #1f2937;
      margin: 0 0 8px 0;
      letter-spacing: 0.2px;
    }
    
    .page-subtitle {
      font-size: 14px;
      color: #667085;
      margin: 0;
      line-height: 1.5;
    }
    
    .card {
      background: #fff;
      border: 0;
      border-radius: 18px;
      padding: 32px 40px;
      box-shadow: 0 10px 30px rgba(16, 24, 40, 0.08);
    }
    
    .section-header {
      margin-bottom: 24px;
    }
    
    .section-title {
      font-weight: 600;
      font-size: 15px;
      color: #1f2937;
      margin: 0 0 6px 0;
    }
    
    .section-hint {
      font-size: 14px;
      color: #667085;
      margin: 0;
      line-height: 1.5;
    }
    
    label {
      display: block;
      font-weight: 600;
      font-size: 14px;
      color: #344054;
      margin: 0 0 8px 0;
    }
    
    input[type="text"], 
    input[type="file"] {
      width: 100%;
      padding: 12px 14px;
      border: 1px solid #d0d5dd;
      border-radius: 14px;
      background: #fff;
      font-size: 14px;
      color: #1f2937;
      transition: all 0.2s;
    }
    
    input[type="text"]::placeholder {
      color: #9ca3af;
    }
    
    input[type="text"]:focus {
      outline: none;
      border-color: #2563eb;
      box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
    }
    
    input[type="file"] {
      padding: 10px 14px;
      cursor: pointer;
      font-size: 13px;
    }
    
    .grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 24px;
      margin-bottom: 24px;
    }
    
    .form-group {
      display: flex;
      flex-direction: column;
    }
    
    .btnrow {
      margin-top: 32px;
      padding-top: 28px;
      border-top: 1px solid #eaecf0;
      display: flex;
      gap: 12px;
      flex-wrap: wrap;
    }
    
    .btn {
      display: inline-block;
      padding: 12px 20px;
      border-radius: 999px;
      text-decoration: none;
      cursor: pointer;
      border: none;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.2s;
      text-align: center;
    }
    
    .btn-primary {
      background: #2563eb;
      color: #fff;
      padding-inline: 24px;
    }
    
    .btn-primary:hover {
      background: #1d4ed8;
      transform: translateY(-1px);
      box-shadow: 0 4px 12px rgba(37, 99, 235, 0.25);
    }
    
    .btn-primary:active {
      transform: translateY(0);
    }
    
    .alert-ok {
      background: #d1fae5;
      color: #065f46;
      padding: 14px 16px;
      border-radius: 12px;
      margin-bottom: 24px;
      border: 1px solid #a7f3d0;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    
    .hint {
      font-size: 13px;
      color: #667085;
      margin-top: 8px;
      line-height: 1.4;
    }
    
    .preview-wrapper {
      margin-top: 14px;
      padding: 14px;
      background: #f9fafb;
      border-radius: 12px;
      border: 1px solid #e5e7eb;
    }
    
    .preview-label {
      font-size: 13px;
      color: #667085;
      margin: 0 0 10px 0;
    }
    
    img.preview {
      border-radius: 10px;
      border: 1px solid #e5e7eb;
      max-width: 100%;
      display: block;
      background: #fff;
    }
    
    .preview-logo {
      height: 80px;
      object-fit: contain;
    }
    
    .preview-hero {
      height: 200px;
      object-fit: cover;
      width: 100%;
    }
    
    /* Tablet (768px - 1024px) */
    @media (max-width: 1024px) {
      .wrap {
        padding: 20px 14px;
      }
      
      .card {
        padding: 28px 32px;
      }
    }
    
    /* Mobile Landscape & Small Tablet (600px - 767px) */
    @media (max-width: 767px) {
      .wrap {
        padding: 18px 12px;
      }
      
      .page-title {
        font-size: 24px;
      }
      
      .card {
        padding: 24px;
        border-radius: 16px;
      }
      
      .grid {
        grid-template-columns: 1fr;
        gap: 20px;
      }
      
      .preview-hero {
        height: 160px;
      }
    }
    
    /* Mobile Portrait (up to 599px) */
    @media (max-width: 599px) {
      .wrap {
        padding: 16px 10px;
      }
      
      .page-header {
        margin-bottom: 20px;
      }
      
      .page-title {
        font-size: 22px;
      }
      
      .page-subtitle {
        font-size: 13px;
      }
      
      .card {
        padding: 20px 18px;
        border-radius: 14px;
      }
      
      .section-header {
        margin-bottom: 20px;
      }
      
      .grid {
        gap: 18px;
        margin-bottom: 18px;
      }
      
      label {
        font-size: 13px;
      }
      
      input[type="text"], 
      input[type="file"] {
        padding: 11px 12px;
        font-size: 14px;
      }
      
      .btn {
        padding: 11px 20px;
        font-size: 14px;
        width: 100%;
      }
      
      .btnrow {
        margin-top: 24px;
        padding-top: 22px;
      }
      
      .preview-logo {
        height: 60px;
      }
      
      .preview-hero {
        height: 140px;
      }
      
      .alert-ok {
        padding: 12px 14px;
        font-size: 13px;
      }
    }
    
    /* Extra Small Mobile (up to 375px) */
    @media (max-width: 375px) {
      .wrap {
        padding: 14px 8px;
      }
      
      .card {
        padding: 18px 14px;
      }
      
      .page-title {
        font-size: 20px;
      }
      
      .preview-hero {
        height: 120px;
      }
    }
  </style>
</head>
<body>

  <div class="wrap">
    <?php if (session()->getFlashdata('success')): ?>
      <div class="alert-ok">
        <div>✅</div>
        <div><?= esc(session()->getFlashdata('success')) ?></div>
      </div>
    <?php endif; ?>

    <div class="card">
      <div class="section-header">
        <div class="section-title">Edit Konten</div>
        <div class="section-hint">Atur informasi branding yang akan tampil di halaman publik sekolah.</div>
      </div>

      <form action="<?= site_url('admin/informasi/branding') ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>
        <input type="hidden" name="redirect_to" value="<?= current_url() ?>">

        <div class="grid">
          <div class="form-group">
            <label>Nama Sekolah</label>
            <input type="text" name="school_name" value="<?= esc($row['school_name'] ?? '') ?>" placeholder="Contoh: SMAS SENTOSA BHAKTI">
          </div>

          <div class="form-group">
            <label>Tagline</label>
            <input type="text" name="tagline" value="<?= esc($row['tagline'] ?? '') ?>" placeholder="Sesuai jargon sekolah">
          </div>
        </div>

        <div class="grid">
          <div class="form-group">
            <label>Logo Sekolah</label>
            <input type="file" name="logo" accept="image/*">
            <div class="hint">Format: JPG, PNG, SVG (Maks. 2MB)</div>

            <?php if (!empty($row['logo_path'])): ?>
              <div class="preview-wrapper">
                <div class="preview-label">Logo saat ini:</div>
                <img class="preview preview-logo" src="<?= base_url($row['logo_path']) ?>" alt="Logo">
              </div>
            <?php else: ?>
              <div class="hint" style="margin-top:12px;">Belum ada logo tersimpan.</div>
            <?php endif; ?>
          </div>

          <div class="form-group">
            <label>Background Hero</label>
            <input type="file" name="hero_bg" accept="image/*">
            <div class="hint">Format: JPG, PNG (Maks. 5MB, Rekomendasi: 1920x600px)</div>

            <?php if (!empty($row['hero_bg_path'])): ?>
              <div class="preview-wrapper">
                <div class="preview-label">Background saat ini:</div>
                <img class="preview preview-hero" src="<?= base_url($row['hero_bg_path']) ?>" alt="Hero Background">
              </div>
            <?php else: ?>
              <div class="hint" style="margin-top:12px;">Belum ada background tersimpan.</div>
            <?php endif; ?>
          </div>
        </div>

        <div class="btnrow">
          <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
        </div>
      </form>
    </div>

  </div>
</body>
</html>